import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
from sklearn import linear_model

SBR = 4

data = np.loadtxt('./FC_SBR%ddB_log.log'%(SBR), skiprows = 0, delimiter = ',', usecols = (0,1,2), dtype = 'float')
First_Layer  = data[:,1]
Second_Layer = data[:,2]
BER          = data[:,0]

from mpl_toolkits.mplot3d import Axes3D
from matplotlib import cm
from sys import argv

#	fig = plt.figure()
#	ax = fig.gca(projection = '3d')
#	ax.set_title("BER Variation of FC NeuralEQ")
#	ax.tricontourf(First_Layer, Second_Layer, BER, zdir = 'z', offset = -1.2, cmap = cm.coolwarm)
#	surf = ax.plot_trisurf(First_Layer, Second_Layer, BER, cmap=cm.jet, linewidth=0.1)
#	fig.colorbar(surf, shrink=0.5, aspect=5)
#	plt.savefig('teste.pdf')
#	plt.show()

import matplotlib.tri as tri

fig, ax = plt.subplots()

y = data[:,1]
x = data[:,2]
z = data[:,0]

#ax.tricontour(x, y, z, levels=30, linewidths=0, colors='k')
cntr = ax.tricontourf(x, y, z, levels=30, cmap="RdBu_r")

ax.set_title("BER Variation of FC NeuralEQ (SBR %ddB)"%(SBR))
fig.colorbar(cntr, ax=ax)
ax.plot(x, y, 'ko', ms=2)

plt.ylabel("First Layer Size")
plt.xlabel("Second Layer Size")
#plt.grid()
plt.savefig('./PlotMaterials/figures/FC-BER-SBR%ddB.png'%(SBR))
plt.show()
